# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Unreleased
### Added

### Changed

### Fixed

### Removed

## 4.8.0 - Saturday, 2 May 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.7.0...4.8.0))
### Added
- Support @hideFromAPIDocumentation on controllers. (https://github.com/mpociot/laravel-apidoc-generator/pull/745)
- Allow strategies to return null. (https://github.com/mpociot/laravel-apidoc-generator/pull/739)

## 4.7.0 - Sunday, 12 April 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.6.0...4.7.0))
### Added
- Support for Laravel Vapor. (https://github.com/mpociot/laravel-apidoc-generator/pull/729)
- Allow customization of static output path. (https://github.com/mpociot/laravel-apidoc-generator/pull/730)

## 4.6.0 - Wednesday, 8 April 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.5.1...4.6.0))
### Added
- Allow `@authenticated` to be set at controller level. (https://github.com/mpociot/laravel-apidoc-generator/pull/726)

## 4.5.1 - Saturday, 4 April 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.5.0...4.5.1))
### Fixed
- Fix version constraint...again. (https://github.com/mpociot/laravel-apidoc-generator/pull/725)

## 4.5.0 - Tuesday, 31 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.4.3...4.5.0))
### Fixed
- Fix version constraints preventing installation on some Laravel 7 installations.

## 4.4.3 - Thursday, 26 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.4.2...4.4.3))
### Fixed
- Fixed link to Postman connection in docs when Laravel autoload is used (https://github.com/mpociot/laravel-apidoc-generator/pull/714)

## 4.4.2 - Sunday, 21 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.4.1...4.4.2))
### Fixed
- Fixed double json encode when fetching collection in Laravel type docs (https://github.com/mpociot/laravel-apidoc-generator/pull/713)


## 4.4.1 - Wednesday, 11 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.4.0...4.4.1))
### Added
- Support for body params as array (https://github.com/mpociot/laravel-apidoc-generator/pull/710)

## 4.4.0 - Saturday, 7 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.3.1...4.4.0))
### Fixed
- Array query params can now be used and render properly (https://github.com/mpociot/laravel-apidoc-generator/pull/700)

## 4.3.1 - Friday, 6 March 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.3.0...4.3.1))
### Changed
- Updated Documentarian dependency for Laravel v7 (https://github.com/mpociot/laravel-apidoc-generator/pull/699)

## 4.3.0 - Saturday, 22 February 2020 ([compare to previous](https://github.com/mpociot/laravel-apidoc-generator/compare/4.2.4...4.3.0))
### Changed
- Updated nunomaduro/collision to include v4 (https://github.com/mpociot/laravel-apidoc-generator/pull/699)

### Fixed
- Use correct protocol for Postman collcetion URL (https://github.com/mpociot/laravel-apidoc-generator/pull/697)

## [4.2.4] - Saturday, 15 February 2020
### Fixed
- Shim URL::formatRoot() on Lumen (https://github.com/mpociot/laravel-apidoc-generator/pull/688)

## [4.2.3] - Tuesday, 4 February 2020
### Changed
- Made "Skipping route" message more descriptive (https://github.com/mpociot/laravel-apidoc-generator/commit/6f61469a9fa8be30e7812cf622a7832163a08bb8)

## [4.2.2] - Tuesday, 21 January 2020
### Fixed
- Set a default value for the routematcher when fetching from config (https://github.com/mpociot/laravel-apidoc-generator/pull/677)

## [4.2.1] - Monday, 20 January 2020
### Fixed
- Fixed autogenerated docs endpoint address for Postman collection (https://github.com/mpociot/laravel-apidoc-generator/pull/673)

## [4.2.0] - Sunday, 19 January 2020
### Added
- New Postman collection generation features (https://github.com/mpociot/laravel-apidoc-generator/pull/666):
  - Properly handle url parameters using the `:param` syntax (opposed to the Laravel-esque `{param}` syntax)
  - Allow configuring the auth section of Postman collection config
  - Add some documentation that was available but not exported in the Postman collection (for URL params and query params)

### Changed
- The package can now create a documentation endpoint automatically for `laravel`-type routes. This also allows users to install the package on dev-only enviornments but have their routes available in others, without writing custom routing code. (https://github.com/mpociot/laravel-apidoc-generator/pull/659)

### Fixed
- Error when installing due to DI not working properly on constructor (https://github.com/mpociot/laravel-apidoc-generator/pull/672)

## [4.1.0] - Monday, 6 January 2019
### Added
- RouteMatcher to use can now be specified by user (https://github.com/mpociot/laravel-apidoc-generator/pull/657)

### Fixed
- Also copy custom logo for non-static docs (https://github.com/mpociot/laravel-apidoc-generator/commit/720f9c9e9b2443bcfb474b959febaf6cf5c3f004)

## [4.0.2] - Monday, 25 November 2019
### Fixed
- Fixed missing body parameters in response calls (https://github.com/mpociot/laravel-apidoc-generator/commit/5d9371c14391485630941c718d7f168afd540126)
- Add slashes to header values in bash templates to escape special chars (https://github.com/mpociot/laravel-apidoc-generator/commit/e693d746b1c1daf342c28e53daa8f7b34ce9da2b)
- Fixed iteration over null bug - set responses to empty array (https://github.com/mpociot/laravel-apidoc-generator/commit/a24b1e14b17ade8fb4aa1534448904e1075b004c)

## [4.0.1] - Monday, 16 November 2019
### Fixed
- Update rebuild command to work with new docs locations (https://github.com/mpociot/laravel-apidoc-generator/pull/646)

## [4.0.0] - Thursday, 7 November 2019
### Added
- Added `headers` stage (https://github.com/mpociot/laravel-apidoc-generator/pull/624)
- Support for non-static docs, changed source files locations (https://github.com/mpociot/laravel-apidoc-generator/pull/608)
- Support for Eloquent API resources (https://github.com/mpociot/laravel-apidoc-generator/pull/601)
- `bindings` replaced by `@urlParam` annotation (https://github.com/mpociot/laravel-apidoc-generator/pull/599)
- Better support for arrays and objects in bodyParams (https://github.com/mpociot/laravel-apidoc-generator/pull/597)

### Modified
- Postman collection now have the body as `raw` instead of `formdata`. (https://github.com/mpociot/laravel-apidoc-generator/pull/627)
- Nonexistent `@responseFile` annotations now show a warning and skip the route (https://github.com/mpociot/laravel-apidoc-generator/pull/620)
- Use symfony/var-exporter to export PHP arrays, ensuring short array syntax (https://github.com/mpociot/laravel-apidoc-generator/pull/615)
- Use single quotes in PHP example template (https://github.com/mpociot/laravel-apidoc-generator/pull/612)
- Transformer annotations are now given priority over all other response strategies (https://github.com/mpociot/laravel-apidoc-generator/pull/620)
- Made ResponseCalls strategy only execute if no successful responses exist. (https://github.com/mpociot/laravel-apidoc-generator/pull/605)
- Hide null responses in examples. (https://github.com/mpociot/laravel-apidoc-generator/pull/605)
- Made `responses` stage additive (https://github.com/mpociot/laravel-apidoc-generator/pull/605)
- Renamed `query` and `body` in `response_calls` config to `queryParams` and `bodyParams` (https://github.com/mpociot/laravel-apidoc-generator/pull/603)

### Removed
- Removed `apply.response_calls.headers` in favour of `apply.headers` (https://github.com/mpociot/laravel-apidoc-generator/pull/603)
- Removed bindings in response_calls (https://github.com/mpociot/laravel-apidoc-generator/pull/599)

## [3.17.1] - Thursday, 12 September 2019
### Fixed
- ResponseCalls: Call Lumen application correctly since it does not use HttpKernel (https://github.com/mpociot/laravel-apidoc-generator/pull/585)
- Update usage of `clean*Parameters` in python template (https://github.com/mpociot/laravel-apidoc-generator/commit/02fb719d0d6c25e6ce72f30dc8b9604449061156)
- Bugfix: *really* exclude parameters from examples, not just send empty strings (https://github.com/mpociot/laravel-apidoc-generator/commit/762e2e1003d389d6e785d31144eca89c40515926, https://github.com/mpociot/laravel-apidoc-generator/commit/e54b474578b53f97f4737664a63131b315aaf82d)

## [3.17.0] - Saturday, 7 September 2019
### Added
- Switched to a plugin architecture that allows support for external strategies (https://github.com/mpociot/laravel-apidoc-generator/pull/570)

### Changed
- Exclude Laravel Telescope routes when present (https://github.com/mpociot/laravel-apidoc-generator/pull/579)
- Set status code for transformer response from tag if present (https://github.com/mpociot/laravel-apidoc-generator/pull/581)
- Set status code for response call from actual response (https://github.com/mpociot/laravel-apidoc-generator/pull/581)

## [3.16.3] - Thursday, 5 September 2019
### Fixed
- Removed references to removed helper functions in 6.0 (https://github.com/mpociot/laravel-apidoc-generator/pull/576)

## [3.16.2] - Wednesday, 4 September 2019
### Fixed
- Support for Laravel 6 (https://github.com/mpociot/laravel-apidoc-generator/commit/f7dd8d19b75755763e8e20ab4025075eba5cd51a)

## [3.16.1] - Wednesday, 4 September 2019
### Added
- Use HTTPS in Postman collection if base_url is HTTPS (https://github.com/mpociot/laravel-apidoc-generator/pull/575)

## [3.16.0] - Wednesday, 4 September 2019
### Added
- Support for Laravel 6 (https://github.com/mpociot/laravel-apidoc-generator/pull/572)

## [3.15.0] - Saturday, 31 August 2019
### Added
- Ability to exclude a query or body parameter from being included in the example requests (https://github.com/mpociot/laravel-apidoc-generator/pull/552)

## [3.14.0] - Saturday, 31 August 2019
### Fixed
- Backwards compatibility for the changes to `@group` introduced in 3.12.0 (https://github.com/mpociot/laravel-apidoc-generator/commit/5647eda35ebb7f8aed35b31790c5f220b736e985)

## [3.13.0] (deleted)

## [3.12.0] - Sunday, 25 August 2019
### Fixed
- Specifying an `@group` for a method no longer requires you to add the description. (https://github.com/mpociot/laravel-apidoc-generator/pull/556)
- Pass the verbosity level down to the Collision library. (https://github.com/mpociot/laravel-apidoc-generator/pull/556)

## [3.11.0] - Friday, 9 August 2019
### Added
- Support for query parameters in the bash template (https://github.com/mpociot/laravel-apidoc-generator/pull/545)
- Include query parameters and headers in the generated Postman collection (https://github.com/mpociot/laravel-apidoc-generator/pull/537)
- Include Python out of the box as example language (https://github.com/mpociot/laravel-apidoc-generator/pull/524)

### Changed
- Moved nunomaduro/collision to "suggested" so it doesn't break PHP 7.0 (https://github.com/mpociot/laravel-apidoc-generator/commit/2f3a2144e1a4f1eb0229aea8b4d11707cb4aabbf)

### Fixed
- Stopped using config helper inside config file (https://github.com/mpociot/laravel-apidoc-generator/pull/548)

## [3.10.0] - Sunday, 23 June 2019
### Added
- `--verbose` flag to show exception encountered when making response calls (https://github.com/mpociot/laravel-apidoc-generator/commit/dc987f296e5a3d073f56c67911b2cb61ae47e9dc)

## [3.9.0] - Saturday, 8 June 2019
### Modified
- Postman collections and URLs in example requests now use the `apidoc.base_url` config variable (https://github.com/mpociot/laravel-apidoc-generator/pull/523)

## [3.8.0] - Wednesday, 29 May 2019
### Added
- Support for PHP array callable syntax in route action (https://github.com/mpociot/laravel-apidoc-generator/pull/516)

## [3.7.3] - Thursday, 23 May 2019
### Fixed
- Added faker_seed (https://github.com/mpociot/laravel-apidoc-generator/commit/d2901e51a68c17066d4dd96054ff5bfdf124945b)

## [3.7.2] - Sunday, 19 May 2019
### Added
- Support for URL paths in include/exclude rules (https://github.com/mpociot/laravel-apidoc-generator/pull/507)

## [3.7.1] - Friday, 17 May 2019
### Fixed
- Handle exception for no URL::forceRootURL() method in Lumen (https://github.com/mpociot/laravel-apidoc-generator/commit/2146fa114dc18bc32c00b5c5550266d753d5aef3)
- Url parameter bindings (https://github.com/mpociot/laravel-apidoc-generator/commit/f0dc118c6b7792894bf9baa352d7fc4ca8ca74b5)

## [3.7.0] - Thursday, 2 May 2019
### Added
- Support for `@queryParams` in Dingo FormRequests (https://github.com/mpociot/laravel-apidoc-generator/pull/506)
- Easier customisation of example languages (https://github.com/mpociot/laravel-apidoc-generator/commit/0aa737a2e54a913eab4d024a1644c5ddd5dee8b8)
- Include PHP as example language (https://github.com/mpociot/laravel-apidoc-generator/commit/c5814762fa52095fe645716554839b6ae110ef89)

## [3.6.0] - Monday, 29 April 2019
### Added
- Support for `@queryParams` in FormRequests (https://github.com/mpociot/laravel-apidoc-generator/pull/504)
- Added `default_group` key to replace `ungrouped_name` (https://github.com/mpociot/laravel-apidoc-generator/commit/72b5f546c1b84e69fe43c720a04f448c3b96e345)

## [3.5.0] - Tuesday, 23 April 2019
### Added
- Option to seed faker for deterministic output (https://github.com/mpociot/laravel-apidoc-generator/pull/503)
- Support for binding prefixes (https://github.com/mpociot/laravel-apidoc-generator/pull/498)
- Ability to override Laravel `config` (https://github.com/mpociot/laravel-apidoc-generator/pull/496)
- Allow override of the name 'general' for ungrouped routes (https://github.com/mpociot/laravel-apidoc-generator/pull/491)

### Changed
- Use parameter-bound URL in doc examples (https://github.com/mpociot/laravel-apidoc-generator/pull/500)

### Fixed
- Request router now matches when router has sub-domain (https://github.com/mpociot/laravel-apidoc-generator/pull/493)

## [3.4.4] - Saturday, 30 March 2019
### Fixed
- Allow users specify custom Content-type header for Markdown examples (https://github.com/mpociot/laravel-apidoc-generator/pull/486)

## [3.4.3] - Wednesday, 13 March 2019
### Fixed
- Ignore scalar type hints when checking for FormRequests (https://github.com/mpociot/laravel-apidoc-generator/pull/474)

## [3.4.2] - Sunday, 10 March 2019
### Added
- Ability to set cookies on response calls (https://github.com/mpociot/laravel-apidoc-generator/pull/471)

## [3.4.1] - Monday, 4 March 2019
### Fixed
- Support for Lumen 5.7 (https://github.com/mpociot/laravel-apidoc-generator/pull/467)

## [3.4.0] - Wednesday, 27 February 2019
### Added
- Support for Laravel 5.8 (https://github.com/mpociot/laravel-apidoc-generator/pull/462)
- Ability to annotate body parameters on FormRequest (https://github.com/mpociot/laravel-apidoc-generator/pull/460)


## [3.3.2] - Tuesday, 12 February 2019
### Added
- Ability to specify array and object body/query params using dot notation (https://github.com/mpociot/laravel-apidoc-generator/pull/445)
- Ability to specify name and description of Postman collection (https://github.com/mpociot/laravel-apidoc-generator/pull/443)

### Fixed
- Postman collection and documentation base URL now uses `config('app.url')` (https://github.com/mpociot/laravel-apidoc-generator/pull/458)

## [3.3.1] - Tuesday, 8 January 2019
### Fixed
- Fixed vendor tags (https://github.com/mpociot/laravel-apidoc-generator/pull/444)

## [3.3.0] - Wednesday, 2 January 2019
### Added
- Ability to replace json key values in response file (https://github.com/mpociot/laravel-apidoc-generator/pull/434)
- Support for custom transfer serializers (https://github.com/mpociot/laravel-apidoc-generator/pull/441)

## [3.2.0] - Wednesday, 12 December 2018
### Changed
- API groups are now sorted "naturally" (https://github.com/mpociot/laravel-apidoc-generator/pull/428)

### Fixed
- Partial resource controllers are now properly supported (https://github.com/mpociot/laravel-apidoc-generator/pull/429)
- PUT request body now formatted as `urlencoded` in Postman collection (https://github.com/mpociot/laravel-apidoc-generator/pull/418)
- `@responseFile` strategy now properly renders responses (https://github.com/mpociot/laravel-apidoc-generator/pull/427)

## [3.1.1] - Wednesday, 5 December 2018
### Added
- Ability to specify different responses for different status codes. (https://github.com/mpociot/laravel-apidoc-generator/pull/416)

## [3.1.0] - Wednesday, 28 November 2018
### Added
- Add `ResponseFileStrategy` to retrieve responses from files. (https://github.com/mpociot/laravel-apidoc-generator/pull/410)

### Modified
- Switch from `jQuery` to `fetch` in JavaScript examples. (https://github.com/mpociot/laravel-apidoc-generator/pull/411)

## [3.0.6] - Saturday, 24 November 2018
### Added
- `include` and `exclude` route options now support wildcards (https://github.com/mpociot/laravel-apidoc-generator/pull/409)

## [3.0.5] - Thursday, 15 November 2018
### Fixed
- Make `router` option case-insensitive (https://github.com/mpociot/laravel-apidoc-generator/pull/407)

## [3.0.4] - Wednesday, 7 November 2018
### Fixed
- Replaced use of `Storage::copy` with PHP's `copy` to work with absolute paths (https://github.com/mpociot/laravel-apidoc-generator/pull/404)

## [3.0.3] - Friday, 2 November 2018
### Fixed
- Replaced use of `config_path` with more generic option for better Lumen compatibility (https://github.com/mpociot/laravel-apidoc-generator/pull/398)

## [3.0.2] - Friday, 26 October 2018
### Added
- Ability to specify examples for body and query parameters (https://github.com/mpociot/laravel-apidoc-generator/pull/394)
### Fixed
- Rendering of example requests' descriptions (https://github.com/mpociot/laravel-apidoc-generator/pull/393)

## [3.0.1] - Monday, 22 October 2018
### Fixed
- Rendering of query parameters' descriptions (https://github.com/mpociot/laravel-apidoc-generator/pull/387)

## [3.0] - Sunday, 21 October 2018
### Added
- Official Lumen support (https://github.com/mpociot/laravel-apidoc-generator/pull/382)
- `@queryParam` annotation (https://github.com/mpociot/laravel-apidoc-generator/pull/383)
- `@bodyParam` annotation (https://github.com/mpociot/laravel-apidoc-generator/pull/362, https://github.com/mpociot/laravel-apidoc-generator/pull/366)
- `@authenticated` annotation (https://github.com/mpociot/laravel-apidoc-generator/pull/369)
- Ability to override the controller `@group` from the method. (https://github.com/mpociot/laravel-apidoc-generator/pull/372)
- Ability to use a custom logo (https://github.com/mpociot/laravel-apidoc-generator/pull/368)

### Changed
- Moved from command-line options to a config file  (https://github.com/mpociot/laravel-apidoc-generator/pull/362)
- Commands have been renamed to the `apidoc` namespace (previously `api`). (https://github.com/mpociot/laravel-apidoc-generator/pull/350)
- The `update` command has been renamed to `rebuild` and now uses the output path configured in the config file. (https://github.com/mpociot/laravel-apidoc-generator/pull/370)
- `@resource` renamed to `@group` (https://github.com/mpociot/laravel-apidoc-generator/pull/371)
- Added more configuration options for response calls (https://github.com/mpociot/laravel-apidoc-generator/pull/377)

### Fixed

### Removed
- FormRequest parsing is no longer supported (https://github.com/mpociot/laravel-apidoc-generator/pull/362)
